<?php
try
{
	require('connect.php');
	
	if (isset($_GET['validate_key'])){
		$validate_key = $_GET['validate_key'];
	}
	
	if (isset($_GET['user_idnumber'])){
		$user_idnumber = $_GET['user_idnumber'];
	}
	
	$conn = new PDO("mysql:host=$db_host; dbname=$db_name; charset=utf8", $db_user, $db_pass);
	
	$sql = "SELECT id, formacao, local, nome, emailRetorno, tecnico FROM certificado WHERE validate_key = :key AND user_idnumber = :userId AND inqueritoFill = 0";
		
	$statement = $conn->prepare($sql);
	
	$statement->bindValue(':key', $validate_key);
	$statement->bindValue(':userId', $user_idnumber);
	$statement->execute();
	$row = $statement->fetch(PDO::FETCH_ASSOC);
?>	

<!DOCTYPE html> 
<html>
	<head>
		<title>Certificados - Formadores</title>
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0">
			
		<link rel="stylesheet" href="css/estilos.css">
		<link rel="stylesheet" href="css/sky-forms.css">
		<link rel="stylesheet" href="css/sky-forms-orange.css">
		<!--[if lt IE 9]>
			<link rel="stylesheet" href="css/sky-forms-ie8.css">
		<![endif]-->
		
		<script src="js/jquery.min.js"></script>
		<script src="js/jquery.form.min.js"></script>
		<script src="js/jquery.validate.min.js"></script>		
		<!--[if lt IE 10]>
			<script src="js/jquery.placeholder.min.js"></script>
		<![endif]-->		
		<!--[if lt IE 9]>
			<script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
			<script src="js/sky-forms-ie8.js"></script>
		<![endif]-->
	</head>
	
	<body class="bg-orange">
		<div class="body">
			<form method="post" id="sky-form" name = "sky-form" class="sky-form">
				<div id="wait" style="display:none;width:69px;height:89px;border:1px solid black;position:absolute;top:50%;left:50%;padding:2px;"><img src='img/ajax-loader.gif' /><br>Loading..</div>
				<header>QUESTIONÁRIO DE AVALIAÇÃO DA FORMAÇÃO – EAD</header>
<?php
	if($row !== false)
	{
?>				<input type="text" name="certificadoID" id="certificadoID" disabled value="<?php echo $row['id']; ?>" hidden="">
				<fieldset>	
					<section>
						<legend class="separador">Identificação</legend>
						<label class="label">Nome</label>
						<label class="input">
							<input type="text" name="nome" id="nome" disabled value="<?php echo($row['nome']); ?>">
						</label>
					</section>
				
					<section>
						<label class="label">Formação</label>
						<label class="input">
							<input type="text" name="curso" id="curso" disabled value="<?php echo($row['formacao']); ?>">
						</label>
					</section>
				
					<section>
						<legend class="separador">O departamento de formação solicita-lhe o preenchimento do seguinte inquérito, cujo objetivo é recolher a sua opinião acerca do curso/módulo em que participou enquanto formador/a. A sua opinião é fundamental para a melhoria contínua da nossa formação.
						Agradecemos desde já a sua colaboração!</legend>
						<label class="label">1.	OBJETIVOS/RESULTADOS</label>
						<label class="label preto">1.1 Tendo em conta o programa do módulo/curso, indique se os objetivos foram alcançados:</label>
						<div class="inline-group" style="margin-bottom: 50px">
						<label class="radio"><input name="resposta1_1" type="radio" required value="Sem opinião"><i></i>Sem opinião</label>
						<label class="radio"><input name="resposta1_1" type="radio" required value="Não"><i></i>Não</label>
						<label class="radio"><input name="resposta1_1" type="radio" required value="Sim"><i></i>Sim</label>
						</div>
					</section>
					
					<section>
						<label class="label">2. O GRUPO DE APRENDIZAGEM</label>
						<label class="label preto">2.1.	Indique se o grupo de formandos demonstrou:</label>
						
						<div class="inline-group" style="margin-bottom: 50px">
						<section>
							<table width=100%>
								<tr>
									<td width=60%><label class="input">a. Auto motivação para aprender</label></td>							
									<td><label class="radio"><input name="resposta2_1_a" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta2_1_a" type="radio" required value="Não"><i></i>Não</label></td>
									<td><label class="radio"><input name="resposta2_1_a" type="radio" required value="Sim"><i></i>Sim</label></td>
								</tr>
								<tr>
									<td><label class="input">b. Espírito crítico e participação em geral</label></td>
									<td><label class="radio"><input name="resposta2_1_b" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta2_1_b" type="radio" required value="Não"><i></i>Não</label></td>
									<td><label class="radio"><input name="resposta2_1_b" type="radio" required value="Sim"><i></i>Sim</label></td>	
								</tr>
								<tr>
									<td><label class="input">c. Comportamento adequado</label></td>
									<td><label class="radio"><input name="resposta2_1_c" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta2_1_c" type="radio" required value="Não"><i></i>Não</label></td>
									<td><label class="radio"><input name="resposta2_1_c" type="radio" required value="Sim"><i></i>Sim</label></td>
								</tr>
							</table>
						</section>					
						</div>
					</section>
					
					<section>
						<label class="label preto">2.2.	De uma forma global, qual o seu grau de satisfação face ao grupo de formandos?</label>
						<div class="inline-group" style="margin-bottom: 50px">
						<label class="radio"><input name="resposta2_2" type="radio" required value="Sem opinião"><i></i>Sem opinião</label>
						<label class="radio"><input name="resposta2_2" type="radio" required value="Insuficiente"><i></i>Insuficiente</label>
						<label class="radio"><input name="resposta2_2" type="radio" required value="Suficiente"><i></i>Suficiente</label>
						<label class="radio"><input name="resposta2_2" type="radio" required value="Bom"><i></i>Bom</label>
						<label class="radio"><input name="resposta2_2" type="radio" required value="Muito Bom"><i></i>Muito Bom</label>
						</div>
					</section>					
					
					
					<section>
						<label class="label">3.	AUTO AVALIAÇÃO</label>
						<label class="label preto">3.1.	Autoavalie o seu trabalho enquanto formador nas seguintes dimensões:</label>
						
						<div class="inline-group" style="margin-bottom: 50px">
						<section>
							<table width=100%>
								<tr>
									<td width=40%><label class="input">a. Domínio dos assuntos</label></td>
									<td><label class="radio"><input name="resposta3_1_a" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta3_1_a" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta3_1_a" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta3_1_a" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta3_1_a" type="radio" required value="Muito Bom"><i></i>Muito Bom</label></td>
								</tr>
								<tr>
									<td><label class="input">b. Capacidade de comunicação/exposição das matérias</label></td>
									<td><label class="radio"><input name="resposta3_1_b" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta3_1_b" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta3_1_b" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta3_1_b" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta3_1_b" type="radio" required value="Muito Bom"><i></i>Muito Bom</label></td>
								</tr>
								<tr>
									<td><label class="input">c. Capacidade de estimular a aprendizagem dos formandos</label></td>
									<td><label class="radio"><input name="resposta3_1_c" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta3_1_c" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta3_1_c" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta3_1_c" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta3_1_c" type="radio" required value="Muito Bom"><i></i>Muito Bom</label></td>
								</tr>
								<tr>
									<td><label class="input">d. Capacidade de organizar a aula de forma a tornar-se o mais prática possível</label></td>
									<td><label class="radio"><input name="resposta3_1_d" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta3_1_d" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta3_1_d" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta3_1_d" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta3_1_d" type="radio" required value="Muito Bom"><i></i>Muito Bom</label></td>
								</tr>
								<tr>
									<td><label class="input">e. Disponibilidade para esclarecer dúvidas dentro e fora das aulas</label></td>
									<td><label class="radio"><input name="resposta3_1_e" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta3_1_e" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta3_1_e" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta3_1_e" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta3_1_e" type="radio" required value="Muito Bom"><i></i>Muito Bom</label></td>
								</tr>
								<tr>
									<td><label class="input">f. Relacionamento com os formandos</label></td>
									<td><label class="radio"><input name="resposta3_1_f" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta3_1_f" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta3_1_f" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta3_1_f" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta3_1_f" type="radio" required value="Muito Bom"><i></i>Muito Bom</label></td>
								</tr>
								<tr>
									<td><label class="input">g. Adequação e qualidade dos recursos pedagógicos disponibilizados (bibliografia, textos de apoio, slides, etc.)</label></td>
									<td><label class="radio"><input name="resposta3_1_g" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta3_1_g" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta3_1_g" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta3_1_g" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta3_1_g" type="radio" required value="Muito Bom"><i></i>Muito Bom</label></td>
								</tr>
							</table>
						</section>
						</div>
					</section>
					
					
					<section>
						<label class="label">4.	GESTÃO DA FORMAÇÃO</label>
						<label class="label preto">4.1.	Avalie a prestação dos agentes envolvidos na gestão da formação, face aos seguintes parâmetros:</label>
						<label class="label preto">Técnico/a de Formação // <?php echo $row['tecnico']; ?></label>
						<section>
							<table width=100%>
								<tr>
									<td width=50%><label class="input">a. Relacionamento interpessoal</label></td>
									<td><label class="radio"><input name="resposta4_1_1_a" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta4_1_1_a" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta4_1_1_a" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta4_1_1_a" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta4_1_1_a" type="radio" required value="Muito Bom"><i></i>Muito Bom</label></td>
								</tr>
								<tr>
									<td><label class="input">b. Disponibilidade/facilidade de contacto</label></td>
									<td><label class="radio"><input name="resposta4_1_1_b" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta4_1_1_b" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta4_1_1_b" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta4_1_1_b" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta4_1_1_b" type="radio" required value="Muito Bom"><i></i>Muito Bom</label></td>
								</tr>
								<tr>
									<td><label class="input">c. Esclarecimento de dúvidas e resolução de problemas</label></td>
									<td><label class="radio"><input name="resposta4_1_1_c" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta4_1_1_c" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta4_1_1_c" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta4_1_1_c" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta4_1_1_c" type="radio" required value="Muito Bom"><i></i>Muito Bom</label></td>
								</tr>
								<tr>
									<td><label class="input">d. Adequada articulação com a equipa técnico-pedagógica</label></td>
									<td><label class="radio"><input name="resposta4_1_1_d" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta4_1_1_d" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta4_1_1_d" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta4_1_1_d" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta4_1_1_d" type="radio" required value="Muito Bom"><i></i>Muito Bom</label></td>
								</tr>
								<tr>
									<td><label class="input">e. Adequada resolução de questões pedagógicas e organizativas</label></td>
									<td><label class="radio"><input name="resposta4_1_1_e" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta4_1_1_e" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta4_1_1_e" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta4_1_1_e" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta4_1_1_e" type="radio" required value="Muito Bom"><i></i>Muito Bom</label></td>
								</tr>
							</table>
						</section>

						<div class="inline-group" style="margin-bottom: 50px">
						<label class="label preto">Técnico da Sala Virtual</label>
						<section>
							<table width=100%>
								<tr>
									<td width=30%><label class="input">a. Acolhimento e cordialidade</label></td>
									<td><label class="radio"><input name="resposta4_1_2_a" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta4_1_2_a" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta4_1_2_a" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta4_1_2_a" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta4_1_2_a" type="radio" required value="Muito Bom"><i></i>Muito Bom</label></td>
								</tr>
								<tr>
									<td><label class="input">b. Conhecimentos técnicos</label></td>
									<td><label class="radio"><input name="resposta4_1_2_b" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta4_1_2_b" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta4_1_2_b" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta4_1_2_b" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta4_1_2_b" type="radio" required value="Muito Bom"><i></i>Muito Bom</label></td>
								</tr>
								<tr>
									<td><label class="input">c. Sinalização das questões colocadas pelos formandos através do chat</label></td>
									<td><label class="radio"><input name="resposta4_1_2_c" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta4_1_2_c" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta4_1_2_c" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta4_1_2_c" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta4_1_2_c" type="radio" required value="Muito Bom"><i></i>Muito Bom</label></td>	
								</tr>
								<tr>
									<td><label class="input">d. Esclarecimento de dúvidas e resolução de problemas</label></td>
									<td><label class="radio"><input name="resposta4_1_2_d" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta4_1_2_d" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta4_1_2_d" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta4_1_2_d" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta4_1_2_d" type="radio" required value="Muito Bom"><i></i>Muito Bom</label></td>
								</tr>
							</table>
						</section>	
						</div>
					</section>
					
					
					<section>
						<label class="label">5.	PLATAFORMAS DE ENSINO À DISTÂNCIA</label>
						<label class="label preto">5.1.	Como avalia os seguintes aspetos relativos às plataformas de ensino à distância?</label>
						<div class="inline-group" style="margin-bottom: 50px">
						<section>
							<table width=100%>
								<tr>
									<td width=40%><label class="input">a. Informação inicial explicativa do uso da plataforma e esclarecimento relativo às ferramentas e materiais disponíveis</label></td>
									<td><label class="radio"><input name="resposta5_1_a" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta5_1_a" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta5_1_a" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta5_1_a" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta5_1_a" type="radio" required value="Muito Bom"><i></i>Muito Bom</label></td>
								</tr>
								<tr>
									<td><label class="input">b. Facilidade de utilização</label></td>
									<td><label class="radio"><input name="resposta5_1_b" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta5_1_b" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta5_1_b" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta5_1_b" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta5_1_b" type="radio" required value="Muito Bom"><i></i>Muito Bom</label></td>
								</tr>
								<tr>
									<td><label class="input">c. Estrutura e organização das matérias na plataforma</label></td>
									<td><label class="radio"><input name="resposta5_1_c" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta5_1_c" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta5_1_c" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta5_1_c" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta5_1_c" type="radio" required value="Muito Bom"><i></i>Muito Bom</label></td>
								</tr>
								<tr>
									<td><label class="input">d. Qualidade do áudio das sessões síncronas</label></td>
									<td><label class="radio"><input name="resposta5_1_d" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta5_1_d" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta5_1_d" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta5_1_d" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta5_1_d" type="radio" required value="Muito Bom"><i></i>Muito Bom</label></td>
								</tr>
								<tr>
									<td><label class="input">e. Qualidade da imagem das sessões síncronas</label></td>
									<td><label class="radio"><input name="resposta5_1_e" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta5_1_e" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta5_1_e" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta5_1_e" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta5_1_e" type="radio" required value="Muito Bom"><i></i>Muito Bom</label></td>
								</tr>
							</table>
						</section>
						</div>
					</section>
					

					<section>
						<label class="label">6.	ORGANIZAÇÃO</label>
						<section>
							<label class="label preto">6.1.	De uma forma geral, a organização da formação foi:</label>
							<label class="radio"><input name="resposta6_1" type="radio" required value="Sem opinião"><i></i>Sem opinião</label>
							<label class="radio"><input name="resposta6_1" type="radio" required value="Insuficiente"><i></i>Insuficiente</label>
							<label class="radio"><input name="resposta6_1" type="radio" required value="Suficiente"><i></i>Suficiente</label>
							<label class="radio"><input name="resposta6_1" type="radio" required value="Bom"><i></i>Bom</label>
							<label class="radio"><input name="resposta6_1" type="radio" required value="Muito Bom"><i></i>Muito Bom</label>
						</section>
						
						<div class="inline-group" style="margin-bottom: 50px">
						<section>
							<label class="label preto">6.2.	Recomendaria a nossa empresa a outro/a formador/a?</label>
							<label class="radio"><input name="resposta6_2" type="radio" required value="Sem opinião"><i></i>Sem opinião</label>
							<label class="radio"><input name="resposta6_2" type="radio" required value="Não"><i></i>Não</label>
							<label class="radio"><input name="resposta6_2" type="radio" required value="Sim"><i></i>Sim</label>
						</section>
						</div>
					</section>					
					
					
					<section>
						<label class="label">7. COMENTÁRIOS/SUGESTÕES</legend>
						<label class="label preto">Para melhorar a qualidade de futuras ações de formação promovidas pela nossa empresa, será necessário:</label>
						<label class="textarea"><textarea rows="4" name="comentarios"></textarea></label>
					</section>
				</fieldset>
				
				<footer>
					<button type="submit" class="button">Enviar</button>
				</footer>
				
				<div class="message">
					<p>Obrigado pelas respostas, irá receber o seu certificado via email.</p>
				</div>
			</form>			
		</div>
		
		<script type="text/javascript">	
			$(function()
			{				
				$.validator.messages.required = "Por favor responda a todas as perguntas!";
				
				$("#sky-form").validate(
				{					
					// Rules for form validation
					rules:
					{
						resposta11: { required: true }
					},
										
					// Messages for form validation
					messages:
					{
						resposta11: { required: 'Por favor responda a todas as perguntas', }					
					},
										
					// Ajax form submition					
					submitHandler: function(form)
					{								
						var data={
							certificadoID: $('#certificadoID').val(),
							resposta1_1: $('#resposta1_1').val(),
							resposta2_1_a: $('#resposta2_1_a').val(),
							resposta2_1_b: $('#resposta2_1_b').val(),
							resposta2_1_c: $('#resposta2_1_c').val(),
							resposta2_2: $('#resposta2_2').val(),
							resposta3_1_a: $('#resposta3_1_a').val(),
							resposta3_1_b: $('#resposta3_1_b').val(),
							resposta3_1_c: $('#resposta3_1_c').val(),
							resposta3_1_d: $('#resposta3_1_d').val(),
							resposta3_1_e: $('#resposta3_1_e').val(),
							resposta3_1_f: $('#resposta3_1_f').val(),
							resposta3_1_g: $('#resposta3_1_g').val(),
							resposta4_1_1_a: $('#resposta4_1_1_a').val(),
							resposta4_1_1_b: $('#resposta4_1_1_b').val(),
							resposta4_1_1_c: $('#resposta4_1_1_c').val(),
							resposta4_1_1_d: $('#resposta4_1_1_d').val(),
							resposta4_1_1_e: $('#resposta4_1_1_e').val(),
							resposta4_1_2_a: $('#resposta4_1_2_a').val(),
							resposta4_1_2_b: $('#resposta4_1_2_b').val(),
							resposta4_1_2_c: $('#resposta4_1_2_c').val(),
							resposta4_1_2_d: $('#resposta4_1_2_d').val(),
							resposta5_1_a: $('#resposta5_1_a').val(),
							resposta5_1_b: $('#resposta5_1_b').val(),
							resposta5_1_c: $('#resposta5_1_c').val(),
							resposta5_1_d: $('#resposta5_1_d').val(),
							resposta5_1_e: $('#resposta5_1_e').val(),
							resposta6_1: $('#resposta6_1').val(),
							resposta6_2: $('#resposta6_2').val(),
							comentarios: $('#comentarios').val()							
						}
						
						$(form).ajaxSubmit(
						{					
							type: "post",
							url: "formadorSendmail.php",
							data: data,
							cache: false,
							
							beforeSend: function()
							{
								$('#sky-form button[type="submit"]').attr('disabled', true);
							},
							success: function(data)
							{
								$("#sky-form").addClass('submited');
							}
						});
					},
					
					// Do not change code below
					errorPlacement: function(error, element)
					{
						error.insertAfter(element.parent());
					}
				});
			});			
		</script>
<?php
	}
	else
	{
?>
		<div style="background-color: red">
		<div style="color: white; margin-left: 30px">
		<strong>Já respondeu ao inquérito, ou os dados do link são inválido!</strong></div>
		</div
	</body>
</html>

<?php							
	}
}	catch(PDOException $e) {
		echo $e->getMessage();
}
?>