<?php
try
{
	require('connect.php');
	if (isset($_GET['validate_key'])){
		$validate_key = $_GET['validate_key'];
	}
	if (isset($_GET['user_idnumber'])){
		$user_idnumber = $_GET['user_idnumber'];
	}

	$conn = new PDO("mysql:host=$db_host; dbname=$db_name; charset=utf8", $db_user, $db_pass);

	$sql = "SELECT c.id, course.id as id_course, c.course_id, c.filedata, c.filedata_sigo, c.nome, c.formacao, c.inqueritoFill, u.email FROM certificado c INNER JOIN user u ON c.user_idnumber = u.idnumber LEFT JOIN course ON course.shortname=c.course_id WHERE c.validate_key = :key AND c.user_idnumber = :userId";		// AND c.inqueritoFill = 0

	$statement = $conn->prepare($sql);
	$statement->bindValue(':key', $validate_key);
	$statement->bindValue(':userId', $user_idnumber);
	$statement->execute();
	$row = $statement->fetch(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html> 
<html>
	<head>
		<title>Certificados - Formandos</title>
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0">
		<link rel="shortcut icon" href="https://www.institutocriap.com/favicon.ico" />
		<link rel="icon" type="image/png" sizes="32x32" href="https://www.institutocriap.com/favicon-32x32.png">
		<link rel="icon" type="image/png" sizes="16x16" href="https://www.institutocriap.com/favicon-16x16.png">
		<link rel="stylesheet" href="css/estilos.css">
		<link rel="stylesheet" href="css/sky-forms.css">
		<link rel="stylesheet" href="css/sky-forms-orange.css">
		<!--[if lt IE 9]>
			<link rel="stylesheet" href="css/sky-forms-ie8.css">
		<![endif]-->
		
		<script src="js/jquery.min.js"></script>
		<script src="js/jquery.form.min.js"></script>
		<script src="js/jquery.validate.min.js"></script>
		<!--[if lt IE 10]>
			<script src="js/jquery.placeholder.min.js"></script>
		<![endif]-->
		<!--[if lt IE 9]>
			<script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
			<script src="js/sky-forms-ie8.js"></script>
		<![endif]-->
	</head>
	<body class="bg-orange">
		<div class="body">
			<form method="post" id="sky-form" name = "sky-form" class="sky-form">
				<header>INSTRUMENTO DE ACOMPANHAMENTO PÓS-FORMAÇÃO</header>
<?php
	if($row == false)
	{
?>
		<div style="background-color: red">
			<div style="color: white; margin-left: 30px">
				<br><br>
				<p><strong>Dados do link inválidos!</strong></p>
				<br><br>
			</div>
		</div>
	</body>
</html>
<?php
	}
	else
	{
		if ($row['inqueritoFill'] == 1)
		{
			$redirect = "https://ead.institutocriap.com/course/view.php?id=" . $row['id_course'];
			//header( "location:$redirect" );
?>
			<div style="background-color: #cc5000">
				<div style="color: white; margin-left: 30px">
					<br><strong>
					<p>Caro/a formando/a,</p>
					<p>Já recebemos a sua resposta a este questionário, a qual agradecemos novamente.</p>
					<p>Os seus certificados já se encontram disponíveis na plataforma 
					<a style='color:#FFFFFF;' href='https://ead.institutocriap.com/course/view.php?id=<?php echo $row['id_course']; ?>'>Moodle</a>.</p>
					<p>Poderá encontrar estes documentos na barra lateral direita da página desta ação de formação, no separador “Documentos de Formação”.</p>
					<p>Caso surja alguma dificuldade, queira por favor contactar os nossos serviços (+351 225 492 190).</p>
					<br></strong>
				</div>
			</div>
		</body>
	</html>

<?php
		}
		else
		{
?>
				<input type="text" name="certificadoID" id="certificadoID" disabled value="<?php echo $row['id']; ?>" hidden="">
				<input type="text" name="email" id="email" disabled value="<?php echo $row['email']; ?>" hidden="">
				<fieldset>
						<section>
							<legend class="separador">Identificação</legend>
							<label class="label">Nome</label>
							<label class="input">
								<input type="text" name="nome" id="nome" disabled value="<?php echo($row['nome']); ?>">
							</label>
						</section>
						<section>
							<label class="label">Curso</label>
							<label class="input">
								<input type="text" name="curso" id="curso" disabled value="<?php echo($row['formacao']); ?>">
							</label>
						</section>
						<section>
							<legend class="separador">Questionário</legend>
							<label class="label">1# PERTINÊNCIA FACE ÀS NECESSIDADES DE FORMAÇÃO</label>
							<label class="label preto">1.1 Tendo em conta as suas necessidades de aprendizagem, acha que o trabalho desenvolvido durante a formação correspondeu às suas expetativas?</label>
							<div class="inline-group" style="margin-bottom: 50px">
							<label class="radio"><input name="resposta1" type="radio" required value="Sem opinião"><i></i>Sem opinião</label>
							<label class="radio"><input name="resposta1" type="radio" required value="Nada pertinente"><i></i>Nada pertinente</label>
							<label class="radio"><input name="resposta1" type="radio" required value="Pouco pertinente"><i></i>Pouco pertinente</label>
							<label class="radio"><input name="resposta1" type="radio" required value="Pertinente"><i></i>Pertinente</label>
							<label class="radio"><input name="resposta1" type="radio" required value="Bastante Pertinente"><i></i>Bastante Pertinente</label>
							</div>
						</section>
						<section>
							<label class="label">2# APLICABILIDADE</label>
							<label class="label preto">2.1 Considera que o que aprendeu nesta formação está a ser útil e aplicável no seu trabalho ou noutro contexto para si relevante?</label>
							<div class="inline-group" style="margin-bottom: 50px">
							<label class="radio"><input name="resposta2" type="radio" required value="Sem opinião"><i></i>Sem opinião</label>
							<label class="radio"><input name="resposta2" type="radio" required value="Nada útil e aplicável"><i></i>Nada útil e aplicável</label>
							<label class="radio"><input name="resposta2" type="radio" required value="Pouco útil e aplicável"><i></i>Pouco útil e aplicável</label>
							<label class="radio"><input name="resposta2" type="radio" required value="Útil e aplicável"><i></i>Útil e aplicável</label>
							<label class="radio"><input name="resposta2" type="radio" required value="Bastante útil e aplicável"><i></i>Bastante útil e aplicável</label>
							</div>
						</section>
						<section>
							<label class="label">3# EMPREGABILIDADE</label>
							<label class="label preto">3.1 Relativamente à sua situação profissional, neste momento, encontra-se empregado?</label>
							<div class="inline-group" style="margin-bottom: 50px">
							<label class="radio"><input name="resposta3_1" type="radio" required value="Sem opinião"><i></i>Sem opinião</label>
							<label class="radio"><input name="resposta3_1" type="radio" required value="Não"><i></i>Não</label>
							<label class="radio"><input name="resposta3_1" type="radio" required value="Não, sou estudante"><i></i>Não, sou estudante</label>
							<label class="radio"><input name="resposta3_1" type="radio" required value="Sim, mas noutra área"><i></i>Sim, mas noutra área</label>
							<label class="radio"><input name="resposta3_1" type="radio" required value="Sim, na minha área de formação"><i></i>Sim, na minha área de formação</label>
							</div>
						</section>
						<section>
							<label class="label">3# EMPREGABILIDADE</label>
							<label class="label preto">3.2 A frequência da formação no Instituto CRIAP teve alguma influência para entrar no mercado de trabalho/progressão profissional?</label>
							<div class="inline-group" style="margin-bottom: 50px">
							<label class="radio"><input name="resposta3_2" type="radio" required value="Sem opinião"><i></i>Sem opinião</label>
							<label class="radio"><input name="resposta3_2" type="radio" required value="Não"><i></i>Não</label>
							<label class="radio"><input name="resposta3_2" type="radio" required value="Sim"><i></i>Sim</label>
							</div>
						</section>
						<section>
							<label class="label">3# EMPREGABILIDADE</label>
							<label class="label preto">3.3 Se estava desempregado à data da formação e está agora empregado, qual foi o período despendido para entrar no mercado de trabalho após a frequência da formação no Instituto CRIAP?</label>
							<div class="inline-group" style="margin-bottom: 50px">
							<label class="radio"><input name="resposta3_3" type="radio" required value="Sem opinião"><i></i>Sem opinião</label>
							<label class="radio"><input name="resposta3_3" type="radio" required value="Não aplicável"><i></i>Não aplicável</label>
							<label class="radio"><input name="resposta3_3" type="radio" required value="Até 3 meses"><i></i>Até 3 meses</label>
							<label class="radio"><input name="resposta3_3" type="radio" required value="De 6 meses a 1 ano"><i></i>De 6 meses a 1 ano</label>
							<label class="radio"><input name="resposta3_3" type="radio" required value="Mais de 1 ano"><i></i>Mais de 1 ano</label>
							</div>
						</section>
						<section>
							<label class="label">4# PROSSEGUIMENTO DE ESTUDOS</label>
							<label class="label preto">4.1 Considera que a frequência de uma formação no Instituto CRIAP é uma mais-valia para o prosseguimento de estudos (Mestrados e ou Doutoramentos)?</label>
							<div class="inline-group" style="margin-bottom: 50px">
							<label class="radio"><input name="resposta4_1" type="radio" required value="Sem opinião"><i></i>Sem opinião</label>
							<label class="radio"><input name="resposta4_1" type="radio" required value="Não"><i></i>Não</label>
							<label class="radio"><input name="resposta4_1" type="radio" required value="Sim, mas apenas Mestrados"><i></i>Sim, mas apenas Mestrados</label>
							<label class="radio"><input name="resposta4_1" type="radio" required value="Sim, mas apenas Doutoramentos"><i></i>Sim, mas apenas Doutoramentos</label>
							<label class="radio"><input name="resposta4_1" type="radio" required value="Sim, ambos"><i></i>Sim, ambos</label>
							</div>
						</section>
						<section>
							<label class="label">4# PROSSEGUIMENTO DE ESTUDOS</label>
							<label class="label preto">4.2 Após concluir a formação no Instituto CRIAP matriculou-se em algum estabelecimento de ensino superior?</label>
							<div class="inline-group" style="margin-bottom: 50px">
							<label class="radio"><input name="resposta4_2" type="radio" required value="Sem opinião"><i></i>Sem opinião</label>
							<label class="radio"><input name="resposta4_2" type="radio" required value="Não"><i></i>Não</label>
							<label class="radio"><input name="resposta4_2" type="radio" required value="Sim, para concluir ou frequentar outra Licenciatura"><i></i>Sim, para concluir ou frequentar outra Licenciatura</label>
							<label class="radio"><input name="resposta4_2" type="radio" required value="Sim, para concluir ou frequentar o Mestrado"><i></i>Sim, para concluir ou frequentar o Mestrado</label>
							<label class="radio"><input name="resposta4_2" type="radio" required value="Sim, para concluir ou frequentar o Doutoramento"><i></i>Sim, para concluir ou frequentar o Doutoramento</label>
							</div>
						</section>
					<section>
						<label class="label">4# PROSSEGUIMENTO DE ESTUDOS</label>
						<label class="label preto">4.3 Se respondeu afirmativamente à questão anterior, especifique por favor:</label>
						<section>
						<label class="input">
						a) o nome do curso: 
						<input type="text" name="resposta4_3a">
						</label>
						</section>
						<section>
						<label class="input">
						b) o nome do estabelecimento de ensino superior: 
						<input type="text" name="resposta4_3b">
						</label>
						</section>
					</section>
					<section>
							<label class="label">4# PROSSEGUIMENTO DE ESTUDOS</label>
							<label class="label preto">4.4 Foram-lhe atribuídas equivalências?</label>
							<label class="sublinhado">(Responda apenas se o curso a que se inscreveu se enquadrar no âmbito da formação que frequentou no Instituto CRIAP.)</label>
							<div class="inline-group" style="margin-bottom: 50px">
							<label class="radio"><input name="resposta4_4" type="radio" required value="Sem opinião"><i></i>Sem opinião</label>
							<label class="radio"><input name="resposta4_4" type="radio" required value="Não solicitei equivalências"><i></i>Não solicitei equivalências</label>
							<label class="radio"><input name="resposta4_4" type="radio" required value="Não foram atribuídas equivalências"><i></i>Não foram atribuídas equivalências</label>
							<label class="radio"><input name="resposta4_4" type="radio" required value="Foram atribuídas algumas equivalências"><i></i>Foram atribuídas algumas equivalências</label>
							<label class="radio"><input name="resposta4_4" type="radio" required value="Foram atribuídas todas as equivalências solicitadas"><i></i>Foram atribuídas todas as equivalências solicitadas</label>
							</div>
					</section>
					<section>
							<label class="label">5# NOVAS NECESSIDADES DE FORMAÇÃO</label>
							<label class="label preto">5.1 Em que medida estaria interessado/a em frequentar outra ação de formação ministrada pelo Instituto CRIAP?</label>
							<div class="inline-group" style="margin-bottom: 50px">
							<label class="radio"><input name="resposta5_1" type="radio" required value="Sem opinião"><i></i>Sem opinião</label>
							<label class="radio"><input name="resposta5_1" type="radio" required value="Nada interessado/a"><i></i>Nada interessado/a</label>
							<label class="radio"><input name="resposta5_1" type="radio" required value="Pouco interessado/a"><i></i>Pouco interessado/a</label>
							<label class="radio"><input name="resposta5_1" type="radio" required value="Interessado/a"><i></i>Interessado/a</label>
							<label class="radio"><input name="resposta5_1" type="radio" required value="Muito interessado/a"><i></i>Muito interessado/a</label>
							</div>
						</section>
					<section>
							<label class="label">5# NOVAS NECESSIDADES DE FORMAÇÃO</label>
							<label class="label preto">5.2 Na sua opinião, qual a tipologia preferencial para uma formação avançada?</label>
							<div class="inline-group" style="margin-bottom: 50px">
							<label class="radio"><input name="resposta5_2" type="radio" required value="Sem opinião"><i></i>Sem opinião</label>
							<label class="radio"><input name="resposta5_2" type="radio" required value="Curso Intensivo // 8 a 12 horas"><i></i>Curso Intensivo // 8 a 12 horas</label>
							<label class="radio"><input name="resposta5_2" type="radio" required value="Curso Prático // 13 a 24 horas"><i></i>Curso Prático // 13 a 24 horas</label>
							<label class="radio"><input name="resposta5_2" type="radio" required value="Curso Avançado // 50 a 87 horas"><i></i>Curso Avançado // 50 a 87 horas</label>
							<label class="radio"><input name="resposta5_2" type="radio" required value="Especialização Avançada // mais de 88 horas"><i></i>Especialização Avançada // mais de 88 horas</label>
							</div>
					</section>
					<section>
							<label class="label">5# NOVAS NECESSIDADES DE FORMAÇÃO</label>
							<label class="label preto">5.3 Na sua opinião, de que forma deveria decorrer uma formação de maior duração?</label>
							<div class="inline-group" style="margin-bottom: 50px">
							<label class="radio"><input name="resposta5_3" type="radio" required value="Sem opinião"><i></i>Sem opinião</label>
							<label class="radio"><input name="resposta5_3" type="radio" required value="Todos os fins-de-semana, de forma a decorrer no menor espaço de tempo"><i></i>Todos os fins-de-semana, de forma a decorrer no menor espaço de tempo</label>
							<label class="radio"><input name="resposta5_3" type="radio" required value="Dois fins-de-semana seguidos e um de descanso"><i></i>Dois fins-de-semana seguidos e um de descanso</label>
							<label class="radio"><input name="resposta5_3" type="radio" required value="De 15 em 15 dias"><i></i>De 15 em 15 dias</label>
							<label class="radio"><input name="resposta5_3" type="radio" required value="Uma vez por mês"><i></i>Uma vez por mês</label>
							</div>
					</section>
					<section>
							<label class="label">5# NOVAS NECESSIDADES DE FORMAÇÃO</label>
							<label class="label preto">5.4 Na sua opinião, qual seria o horário mais adequado?</label>
							<div class="inline-group" style="margin-bottom: 50px">
							<label class="radio"><input name="resposta5_4" type="radio" required value="Sem opinião"><i></i>Sem opinião</label>
							<label class="radio"><input name="resposta5_4" type="radio" required value="Sábado, dia completo"><i></i>Sábado, dia completo</label>
							<label class="radio"><input name="resposta5_4" type="radio" required value="Sexta-feira pós-laboral + Sábado de manhã"><i></i>Sexta-feira pós-laboral + Sábado de manhã</label>
							<label class="radio"><input name="resposta5_4" type="radio" required value="Sexta-feira pós-laboral + Sábado, dia completo"><i></i>Sexta-feira pós-laboral + Sábado, dia completo</label>
							<label class="radio"><input name="resposta5_4" type="radio" required value="Pós-laboral semanal (ex: Terça e Quinta-feira)"><i></i>Pós-laboral semanal (ex: Terça e Quinta-feira)</label>
							</div>
					</section>
					<section>
						<legend class="separador">Comentários/Sugestões</legend>
						<label class="textarea">
						<textarea rows="4" name="comentarios"></textarea>
						</label>
					</section>
				</fieldset>
				<footer>
					<button type="submit" class="button">Enviar</button>
				</footer>
				<div class="message">
						<div style="background-color:#cc5000; text-align:justify; color:white; font: 13px/1.55 'Open Sans',Helvetica,Arial,sans-serif;">
						<br><strong>
						<p>Caro/a formando/a,</p>
						<p>Agradecemos a sua resposta.</p>
						<p>O seu certificado já se encontra disponível na plataforma 
						<a style='color:#FFFFFF;' href='https://ead.institutocriap.com/course/view.php?id=<?php echo $row['id_course']; ?>'>Moodle</a>.</p>
						<p>Poderá encontrar este documento na barra lateral direita da página desta ação de formação, no separador “Documentos de Formação”.</p>
						<p>Caso surja alguma dificuldade, queira por favor contactar os nossos serviços (+351 225 492 190).</p>
						<br></strong>
					</div>
				</div>
			</form>
		</div>

		<script type="text/javascript">
			$(function()
			{
				$.validator.messages.required = "Por favor responda a todas as perguntas!";
				
				$("#sky-form").validate(
				{
					// Rules for form validation
					rules:
					{
						resposta11: { required: true }
					},

					// Messages for form validation
					messages:
					{
						resposta11: { required: 'Por favor responda a todas as perguntas', }
					},

					// Ajax form submition
					submitHandler: function(form)
					{
						var data={
							certificadoID: $('#certificadoID').val(),
							email: $('#email').val(),
							nome: $('#nome').val(),
							curso: $('#curso').val(),
							resposta1: $('#resposta1').val(),
							resposta2: $('#resposta2').val(),
							resposta3_1: $('#resposta3_1').val(),
							resposta3_2: $('#resposta3_2').val(),
							resposta3_3: $('#resposta3_3').val(),
							resposta4_1: $('#resposta4_1').val(),
							resposta4_2: $('#resposta4_2').val(),
							resposta4_3a: $('#resposta4_3a').val(),
							resposta4_3b: $('#resposta4_3b').val(),
							resposta4_4: $('#resposta4_4').val(),
							resposta5_1: $('#resposta5_1').val(),
							resposta5_2: $('#resposta5_2').val(),
							resposta5_3: $('#resposta5_3').val(),
							resposta5_4: $('#resposta5_4').val(),
							comentarios: $('#comentarios').val()
						}
						
						$(form).ajaxSubmit(
						{
							type: "post",
							url: "formandoSendmail.php",
							data: data,
							cache: false,

							beforeSend: function()
							{
								$('#sky-form button[type="submit"]').attr('disabled', true);
							},
							success: function(data)
							{
								$("#sky-form").addClass('submited');
							}
						});
					},

					// Do not change code below
					errorPlacement: function(error, element)
					{
						error.insertAfter(element.parent());
					}
				});
			});
		</script>
<?php
		}

	}
}	catch(PDOException $e) {
		echo $e->getMessage();
}
?>