<?php
try
{
	require('connect.php');
	
	if (isset($_GET['validate_key'])){
		$validate_key = $_GET['validate_key'];
	}
	
	if (isset($_GET['user_idnumber'])){
		$user_idnumber = $_GET['user_idnumber'];
	}
	
	$conn = new PDO("mysql:host=$db_host; dbname=$db_name; charset=utf8", $db_user, $db_pass);
	
	$sql = "SELECT id, formacao, local, nome, emailRetorno, tecnico FROM certificado WHERE validate_key = :key AND user_idnumber = :userId AND inqueritoFill = 0";
		
	$statement = $conn->prepare($sql);
	
	$statement->bindValue(':key', $validate_key);
	$statement->bindValue(':userId', $user_idnumber);
	$statement->execute();
	$row = $statement->fetch(PDO::FETCH_ASSOC);
?>	

<!DOCTYPE html> 
<html>
	<head>
		<title>Certificados - Formadores</title>
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0">
			
		<link rel="stylesheet" href="css/estilos.css">
		<link rel="stylesheet" href="css/sky-forms.css">
		<link rel="stylesheet" href="css/sky-forms-orange.css">
		
		<script src="js/jquery.min.js"></script>
		<script src="js/jquery.form.min.js"></script>
		<script src="js/jquery.validate.min.js"></script>		
	</head>
	
	<body class="bg-orange">
		<div class="body">
			<form method="post" id="sky-form" name = "sky-form" class="sky-form">
				<div id="wait" style="display:none;width:69px;height:89px;border:1px solid black;position:absolute;top:50%;left:50%;padding:2px;"><img src='img/ajax-loader.gif' /><br>Loading..</div>
				<header>QUESTIONÁRIO DE AVALIAÇÃO DA FORMAÇÃO – EAD</header>
<?php
	if($row !== false)
	{
?>				<input type="text" name="certificadoID" id="certificadoID" disabled value="<?php echo $row['id']; ?>" hidden="">
				<fieldset>	
					<section>
						<legend class="separador">Identificação</legend>
						<label class="label">Nome</label>
						<label class="input">
							<input type="text" name="nome" id="nome" disabled value="<?php echo($row['nome']); ?>">
						</label>
					</section>

					<section>
						<label class="label">Formação</label>
						<label class="input">
							<input type="text" name="curso" id="curso" disabled value="<?php echo($row['formacao']); ?>">
						</label>
					</section>

					<section>
						<legend class="separador">O departamento de formação solicita-lhe o preenchimento do seguinte inquérito, cujo objetivo é recolher a sua opinião acerca do curso/módulo em que participou enquanto formador/a. A sua opinião é fundamental para a melhoria contínua da nossa formação.
						Agradecemos desde já a sua colaboração!</legend>
						<label class="label preto">1. De uma forma global, qual o seu grau de satisfação face ao espírito crítico e participação do grupo de formandos?</label>
						<div class="inline-group" style="margin-bottom: 50px">
						<label class="radio"><input name="resposta1_1" type="radio" required value="Sem opinião"><i></i>Sem opinião</label>
						<label class="radio"><input name="resposta1_1" type="radio" required value="Insuficiente"><i></i>Insuficiente</label>
						<label class="radio"><input name="resposta1_1" type="radio" required value="Suficiente"><i></i>Suficiente</label>
					    <label class="radio"><input name="resposta1_1" type="radio" required value="Bom"><i></i>Bom</label>
						<label class="radio"><input name="resposta1_1" type="radio" required value="Muito bom"><i></i>Muito bom</label>
						</div>
					</section>

					<section>
						<label class="label preto">2. Autoavalie o seu trabalho enquanto formador nas seguintes dimensões:</label>
						<div class="inline-group" style="margin-bottom: 50px">
							<table width=100%>
								<tr>
									<td width=40%><label class="input">Domínio dos assuntos</label></td>
									<td><label class="radio"><input name="resposta2_1" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta2_1" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta2_1" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta2_1" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta2_1" type="radio" required value="Muito bom"><i></i>Muito bom</label></td>
								</tr>
								<tr>
									<td width=40%><label class="input">Capacidade de comunicação e estimulação da aprendizagem dos formandos</label></td>
									<td><label class="radio"><input name="resposta2_2" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta2_2" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta2_2" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta2_2" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta2_2" type="radio" required value="Muito bom"><i></i>Muito bom</label></td>
								</tr>
								<tr>
									<td width=40%><label class="input">Capacidade de organizar a aula de forma a tornar-se o mais prática possível</label></td>
									<td><label class="radio"><input name="resposta2_3" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta2_3" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta2_3" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta2_3" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta2_3" type="radio" required value="Muito bom"><i></i>Muito bom</label></td>
								</tr>
								<tr>
									<td width=40%><label class="input">Disponibilidade para esclarecer dúvidas dentro e fora das aulas</label></td>
									<td><label class="radio"><input name="resposta2_4" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta2_4" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta2_4" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta2_4" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta2_4" type="radio" required value="Muito bom"><i></i>Muito bom</label></td>
								</tr>
								<tr>
									<td width=40%><label class="input">Relacionamento com os formandos</label></td>
									<td><label class="radio"><input name="resposta2_5" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta2_5" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta2_5" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta2_5" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta2_5" type="radio" required value="Muito bom"><i></i>Muito bom</label></td>
								</tr>
								<tr>
									<td width=40%><label class="input">Adequação e qualidade dos recursos pedagógicos disponibilizados (bibliografia, textos de apoio, slides, etc.)</label></td>
									<td><label class="radio"><input name="resposta2_6" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta2_6" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta2_6" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta2_6" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta2_6" type="radio" required value="Muito bom"><i></i>Muito bom</label></td>
								</tr>
							</table>
						</div>
					</section>

					<section>
						<label class="label preto">3. Avalie a prestação dos agentes envolvidos na gestão da formação, face aos seguintes parâmetros:</label>
						<div class="inline-group" style="margin-bottom: 50px">
							<section>
							<label class="label preto">Técnico/a de Formação // <?php echo $row['tecnico']; ?></label>
							<table width=100%>
								<tr>
									<td width=40%><label class="input">Relacionamento interpessoal</label></td>
									<td><label class="radio"><input name="resposta3_1_a" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta3_1_a" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta3_1_a" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta3_1_a" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta3_1_a" type="radio" required value="Muito bom"><i></i>Muito bom</label></td>
								</tr>
								<tr>
									<td><label class="input">Disponibilidade/facilidade de contacto</label></td>
									<td><label class="radio"><input name="resposta3_1_b" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta3_1_b" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta3_1_b" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta3_1_b" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta3_1_b" type="radio" required value="Muito bom"><i></i>Muito bom</label></td>
								</tr>
								<tr>
									<td><label class="input">Esclarecimento de dúvidas e resolução de problemas</label></td>
									<td><label class="radio"><input name="resposta3_1_c" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta3_1_c" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta3_1_c" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta3_1_c" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta3_1_c" type="radio" required value="Muito bom"><i></i>Muito bom</label></td>
								</tr>
							</table>
						</section>

						<section>
							<label class="label preto">Técnico/a da Sala Virtual</label>
							<table width=100%>
								<tr>
									<td width=40%><label class="input">Acolhimento e cordialidade</label></td>
									<td><label class="radio"><input name="resposta3_2_a" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta3_2_a" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta3_2_a" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta3_2_a" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta3_2_a" type="radio" required value="Muito bom"><i></i>Muito bom</label></td>
								</tr>
								<tr>
									<td><label class="input">Sinalização das questões colocadas pelos formandos através do chat</label></td>
									<td><label class="radio"><input name="resposta3_2_b" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta3_2_b" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta3_2_b" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta3_2_b" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta3_2_b" type="radio" required value="Muito bom"><i></i>Muito bom</label></td>
								</tr>
								<tr>
									<td><label class="input">Esclarecimento de dúvidas e resolução de problemas técnicos</label></td>
									<td><label class="radio"><input name="resposta3_2_c" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta3_2_c" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta3_2_c" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta3_2_c" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta3_2_c" type="radio" required value="Muito bom"><i></i>Muito bom</label></td>
								</tr>
							</table>
						</section>
					</div>
					</section>

					<section>
						<label class="label preto">4. Como avalia os seguintes aspetos relativos às plataformas de ensino à distância?</label>
						<div class="inline-group" style="margin-bottom: 50px">
							<table width=100%>
								<tr>
									<td width=40%><label class="input">Esclarecimento do uso da plataforma e suas ferramentas</label></td>
									<td><label class="radio"><input name="resposta4_1" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta4_1" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta4_1" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta4_1" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta4_1" type="radio" required value="Muito bom"><i></i>Muito bom</label></td>
								</tr>
								<tr>
									<td width=40%><label class="input">Facilidade de utilização</label></td>
									<td><label class="radio"><input name="resposta4_2" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta4_2" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta4_2" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta4_2" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta4_2" type="radio" required value="Muito bom"><i></i>Muito bom</label></td>
								</tr>
								<tr>
									<td width=40%><label class="input">Qualidade do áudio das sessões síncronas</label></td>
									<td><label class="radio"><input name="resposta4_3" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta4_3" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta4_3" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta4_3" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta4_3" type="radio" required value="Muito bom"><i></i>Muito bom</label></td>
								</tr>
								<tr>
									<td width=40%><label class="input">Qualidade da imagem das sessões síncronas</label></td>
									<td><label class="radio"><input name="resposta4_4" type="radio" required value="Sem opinião"><i></i>Sem opinião</label></td>
									<td><label class="radio"><input name="resposta4_4" type="radio" required value="Insuficiente"><i></i>Insuficiente</label></td>
									<td><label class="radio"><input name="resposta4_4" type="radio" required value="Suficiente"><i></i>Suficiente</label></td>
									<td><label class="radio"><input name="resposta4_4" type="radio" required value="Bom"><i></i>Bom</label></td>
									<td><label class="radio"><input name="resposta4_4" type="radio" required value="Muito bom"><i></i>Muito bom</label></td>
								</tr>
							</table>
					</div>
					</section>

					<section>
						<label class="label">5. De uma forma geral, a organização da formação foi:</label>
						<div class="inline-group" style="margin-bottom: 50px">
						<label class="radio"><input name="resposta5_1" type="radio" required value="Sem opinião"><i></i>Sem opinião</label>
						<label class="radio"><input name="resposta5_1" type="radio" required value="Insuficiente"><i></i>Insuficiente</label>
						<label class="radio"><input name="resposta5_1" type="radio" required value="Suficiente"><i></i>Suficiente</label>
					    <label class="radio"><input name="resposta5_1" type="radio" required value="Bom"><i></i>Bom</label>
						<label class="radio"><input name="resposta5_1" type="radio" required value="Muito bom"><i></i>Muito bom</label>
						</div>
					</section>

					<section>
						<label class="label">6. Recomendaria a nossa empresa a outro/a formador/a?</label>
						<div class="inline-group" style="margin-bottom: 50px">
						<label class="radio"><input name="resposta6_1" type="radio" required value="Sem opinião"><i></i>Sem opinião</label>
						<label class="radio"><input name="resposta6_1" type="radio" required value="Não"><i></i>Não</label>
						<label class="radio"><input name="resposta6_1" type="radio" required value="Sim"><i></i>Sim</label>
						</div>
					</section>
					
					<section>
						<label class="label">7. COMENTÁRIOS/SUGESTÕES</legend>
						<label class="label preto">Para melhorar a qualidade de futuras ações de formação promovidas pela nossa empresa, será necessário:</label>
						<label class="textarea"><textarea rows="4" name="comentarios"></textarea></label>
					</section>
				</fieldset>
				
				<footer>
					<button type="submit" class="button">Enviar</button>
				</footer>
				
				<div class="message">
					<p>Obrigado pelas respostas, irá receber o seu certificado via email.</p>
				</div>
			</form>			
		</div>
		
		<script type="text/javascript">	
			$(function()
			{				
				$.validator.messages.required = "Por favor responda a todas as perguntas!";
				
				$("#sky-form").validate(
				{					
					// Rules for form validation
					rules:
					{
						resposta11: { required: true }
					},
										
					// Messages for form validation
					messages:
					{
						resposta11: { required: 'Por favor responda a todas as perguntas', }					
					},
										
					// Ajax form submition					
					submitHandler: function(form)
					{								
						var data={
							certificadoID: $('#certificadoID').val(),
						    resposta1_1: $('#resposta1_1').val(),
							resposta2_1: $('#resposta2_1').val(),
							resposta2_2: $('#resposta2_2').val(),
							resposta2_3: $('#resposta2_3').val(),
							resposta2_4: $('#resposta2_4').val(),
							resposta2_5: $('#resposta2_5').val(),
							resposta2_6: $('#resposta2_6').val(),
							resposta3_1_a: $('#resposta3_1_a').val(),
							resposta3_1_b: $('#resposta3_1_b').val(),
							resposta3_1_c: $('#resposta3_1_c').val(),
							resposta3_2_a: $('#resposta3_2_a').val(),
							resposta3_2_b: $('#resposta3_2_b').val(),
							resposta3_2_c: $('#resposta3_2_c').val(),
							resposta4_1: $('#resposta4_1').val(),
							resposta4_2: $('#resposta4_2').val(),
							resposta4_3: $('#resposta4_3').val(),
							resposta4_4: $('#resposta4_4').val(),
							resposta5_1: $('#resposta5_1').val(),
							resposta6_1: $('#resposta6_1').val(),
							comentarios: $('#comentarios').val()							
						}
						
						$(form).ajaxSubmit(
						{					
							type: "post",
							url: "formadorSendmail.php",
							data: data,
							cache: false,
							
							beforeSend: function()
							{
								$('#sky-form button[type="submit"]').attr('disabled', true);
							},
							success: function(data)
							{
								$("#sky-form").addClass('submited');
							}
						});
					},
					
					// Do not change code below
					errorPlacement: function(error, element)
					{
						error.insertAfter(element.parent());
					}
				});
			});			
		</script>
<?php
	}
	else
	{
?>
		<div style="background-color: red">
		<div style="color: white; margin-left: 30px">
		<strong>Já respondeu ao inquérito, ou os dados do link são inválido!</strong></div>
		</div
	</body>
</html>

<?php							
	}
}	catch(PDOException $e) {
		echo $e->getMessage();
}
?>